var usbDetect = require('usb-detection');
const drivelist = require('drivelist');

usbDetect.startMonitoring();

var retries = 0;

async function checkDrivesList(){
  var drives = await drivelist.list();
  drives = drives.filter(d=> !d.device.startsWith('/dev/mmcblk0'));
  console.log(drives);
  if(drives.length>0)
  {
	var usbdrive = drives[0];
	if(usbdrive.mountpoints.length>0)
	{		
	  var mount = usbdrive.mountpoints[0].path;
	  console.log("Mounted on "+mount);
	  if(require('fs').existsSync(mount)){
		await require('child_process').execSync('chmod 777 '+mount);
	  	await require('child_process').execSync('chown -R wiboot:wiboot '+mount);
	  }

	  if(require('fs').existsSync(mount+'/autorun.sh'))
		await require('child_process').execSync('bash '+mount+'/autorun.sh '+mount);
	}
	else if(retries<3)
	{
	  retries++;
	  console.log("Mounting USB drive....");
	  //await require('child_process').execSync('mount -t vfat /dev/sda1 /media');
	  setTimeout(checkDrivesList,5000);
	}
	else
	{
	  console.log("Problem when trying USB drive mount!!!!");
	}
  }
  else
  {
    retries++;
    console.log("Re-checking....");
    setTimeout(checkDrivesList,5000);
  }
}

usbDetect.on('add', async function(device) {
  console.log(device);
  //var result = await require('child_process').execSync('usb-devices');
  //var usbs = result.toString('utf-8');
  //console.log(usbs);
  retries=0;
  setTimeout(checkDrivesList,10000);
});
// After this call, the process will be able to quit
//usbDetect.stopMonitoring();
